--Order of Battle - Aircraft/Helicopter
--organized in units (squadrons/regiments) containing a number of aircraft
--Campaign Version-V20.00
--[[ Unit Entry Example ----------------------------------------------------------------------------

[1] = {
	inactive = true,								--true if unit is not active
	player = true,									--true for player unit
	name = "527 TFS",								--unit name
	type = "F-5E-3",								--aircraft type
	helicopter = true,								--true for helicopter units
	country = "USA",								--unit country
	livery = {"USAF Euro Camo"},					--unit livery
	base = "Groom Lake AFB",						--unit base
	skill = "Random",								--unit skill
	tasks = {										--list of eligible unit tasks. Note: task names do not necessary match DCS tasks)
		["AWACS"] = true,							
		["Anti-ship Strike"] = true,
		["CAP"] = true,
		["Fighter Sweep"] = true,	
		["Intercept"] = true,
		["Reconnaissance"] = true,
		["Refueling"] = true,
		["Strike"] = true,							--Generic air-ground task (replaces "Ground Attack", "CAS" and "Pinpoint Strike")
		["Transport"] = true,
		["Escort"] = true,							--Support task: Fighter escort for package
		["SEAD"] = true,							--Support task: SEAD escort for package
		["Escort Jammer"] = true,					--Support task: Single airraft in center of package for defensive jamming
		["Flare Illumination"] = true,				--Support task: Illuminate target with flares for package
		["Laser Illumination"] = true,				--Support task: Lase target for package
		["Stand-Off Jammer"] = true,				--Not implemeted yet: On-station jamming
		["Chaff Escort"] = true,					--Not implemented yet: Lay chaff corrdior ahead of package
		["A-FAC"] = true,							--Not implemented yet: Airborne forward air controller
	},
	number = 12,									--number of airframes
},

]]-----------------------------------------------------------------------------------------------------

oob_air = {
	["blue"] = {											--side 1
		[1] = {
			name = "F7",								--unit name
			player = true,									--player unit
			type = "AJS37",								--aircraft type
			country = "Sweden",								--unit country
			livery = {"M90K"},					--unit livery
			base = "Al Dhafra AB",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = true,
				["Anti-ship Strike"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 2,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 3,
			},
			number = 12,
		},
		[2] = {
			name = "F21",								--unit name
			inactive = true,
			type = "AJS37",									--aircraft type
			country = "Sweden",								--unit country
			base = "Reserves",								--unit base
			tasks = {},										--unit tasks
			number = 30,
		},
		[3] = {
			name = "EC 1/12",								--unit name
			player = false,									--player unit
			type = "M-2000C",								--aircraft type
			country = "France",								--unit country
			livery = {"AdA 1-12 Cambresis 103-KN", "AdA 1-12 Cambresis 103-LB", "AdA 1-12 Cambresis 103-YD", "AdA 1-12 Cambresis 103-YE", "AdA 1-12 Cambresis 103-YF"},					--unit livery
			base = "Al Dhafra AB",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Strike"] = true,
				["Intercept"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 0.5,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 2,
				["CAP"] = 1.5,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
			},
			number = 8,
		},
		[4] = {
			name = "EC 2/12",								--unit name
			inactive = true,
			type = "M-2000C",									--aircraft type
			country = "France",								--unit country
			base = "Reserves",								--unit base
			tasks = {},										--unit tasks
			number = 30,
		},
		[5] = {
			name = "58 TFS",								--unit name
			player = false,									--player unit
			type = "F-15C",									--aircraft type
			country = "USA",								--unit country
			livery = "58th Fighter SQN (EG)",				--unit livery
			base = "Dubai Intl",						--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Intercept"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 2,
				["CAP"] = 2,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
			},
			number = 8,
		},
		[6] = {
			name = "R/58 TFS",								--unit name
			inactive = true,
			type = "F-15C",									--aircraft type
			country = "USA",								--unit country
			base = "Reserves",								--unit base
			tasks = {},										--unit tasks
			number = 18,
		},
		[7] = {
			name = "335 TFS",								--unit name
			type = "F-15E",									--aircraft type
			country = "USA",								--unit country
			livery = "335th Fighter SQN (SJ)",				--unit livery
			base = "Al Dhafra AB",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 2,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
			},
			number = 6,
		},
		[8] = {
			name = "R/335 TFS",								--unit name
			inactive = true,
			type = "F-15E",									--aircraft type
			country = "USA",								--unit country
			base = "Reserves",								--unit base
			tasks = {},										--unit tasks
			number = 18,
		},
		[9] = {
			name = "17 TFS",								--unit name
			type = "F-16C bl.52d",							--aircraft type
			country = "USA",								--unit country
			livery = "",			--unit livery
			base = "Al Maktoum Intl",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,
				["SEAD"] = true,
				["Laser Illumination"] = true,				
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 2,								-- coef normal : = 1
				["SEAD"] = 2,
				["Laser Illumination"] = 3,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
			},
			number = 8,
		},
		[10] = {
			name = "R/17 TFS",								--unit name
			inactive = true,
			type = "F-16C bl.52d",							--aircraft type
			country = "USA",								--unit country
			base = "Reserves",								--unit base
			tasks = {},										--unit tasks
			number = 24,
		},
		[11] = {
			name = "VFA-106",								--unit name
			player = false,									--player unit
			type = "FA-18C_hornet",							--aircraft type
			country = "USA",								--unit country
			livery = "vfa-106",								--unit livery	livery = "VFA-131",
			liveryModex = {									--unit livery Modex  (optional)
				[200] = "vfa-106 high visibility",
				},
			sidenumber = {200, 215},														 
			base = "CVN-71 Theodore Roosevelt",				--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["SEAD"] = true,
				["Intercept"] = true,
				["CAP"] = true,
				["Fighter Sweep"] = true,
				["Escort"] = true,
				["Strike"] = true,
				["Anti-ship Strike"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1.5,								-- coef normal : = 1
				["SEAD"] = 2,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 0.2,
				["Escort"] = 0.5,
				["Fighter Sweep"] = 0.2,
				["Anti-ship Strike"] = 2,
			},
			number = 16,
		},
		[12] = {
			name = "R/VFA-106",								--unit name
			inactive = true,
			type = "F/A-18C",								--aircraft type
			country = "USA",								--unit country
			base = "Reserves",								--unit base
			tasks = {},										--unit tasks
			number = 28,
		},
		[13] = {
			name = "417 TFS",								--unit name
			type = "F-117A",								--aircraft type
			country = "USA",								--unit country
			livery = "usaf standard",						--unit livery
			base = "Al Dhafra AB",								--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 2,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
			},
			number = 4,
		},
		[14] = {
			name = "171 ARW",								--unit name
			type = "KC135MPRS",								--aircraft type
			country = "USA",								--unit country
			livery = "",									--unit livery
			base = "Dubai Intl",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Refueling"] = true,
			},
			number = 3,
		},
		[15] = {
			name = "R/171 ARW",								--unit name
			inactive = true,
			type = "KC135MPRS",									--aircraft type
			country = "USA",								--unit country
			base = "Reserves",							--unit base
			skill = "High",								--unit skill
			tasks = {},									--unit tasks
			number = 9,
		},		
		[16] = {
			name = "174 ARW",								--unit name
			type = "S-3B Tanker",								--aircraft type
			country = "USA",								--unit country
			livery = "",									--unit livery
			base = "CVN-71 Theodore Roosevelt",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Refueling"] = true,
			},
			number = 4,
		},
		[17] = {
			name = "R/174 ARW",								--unit name
			inactive = true,
			type = "S-3B Tanker",									--aircraft type
			country = "USA",								--unit country
			base = "Reserves",							--unit base
			skill = "High",								--unit skill
			tasks = {},									--unit tasks
			number = 6,
		},
		[18] = {
			name = "7 ACCS",								--unit name
			type = "E-3A",									--aircraft type
			country = "USA",								--unit country
			livery = "usaf standard",						--unit livery
			base = "Al Maktoum Intl",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["AWACS"] = true,
			},
			number = 3,
		},
		[19] = {
			name = "VF-101",							--unit name
			player = false,									--player unit
			type = "F-14B",								--aircraft type
			country = "USA",								--unit country
			livery = {"vf-101 grim reapers low vis", "vf-101 dark"},				--unit livery
			liveryModex = {									--unit livery Modex  (optional)
				[100] = "vf-101 red",
				[105] = "vf-101 grim reapers low vis",
				[111] = "vf-101 dark",
				},
			sidenumber = {100, 115},														 
			base = "CVN-71 Theodore Roosevelt",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Strike"] = false,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,	
			},
			number = 16,
		},
		[20] = {
			name = "R/VF-101",								--unit name
			inactive = true,
			type = "F-14B",								--aircraft type
			base = "Reserves",
			skill = "High",								--unit skill
			tasks = {},										--unit tasks
			number = 24,
		},
		[21] = {
			name = "13 TFS",								--unit name
			player = false,									--player unit
			type = "F-16C_50",							--aircraft type
			country = "USA",								--unit country
			livery = "13th_Fighter_Squadron",			--unit livery
			base = "Al Dhafra AB",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,
				["SEAD"] = false,
				["Laser Illumination"] = false,
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,	
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1.5,								-- coef normal : = 1
				["SEAD"] = 2,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1.5,
				["Escort"] = 1,
				["Fighter Sweep"] = 0.2,
				["Anti-ship Strike"] = 1,
			},
			number = 8,
		},
		[22] = {
			name = "R/13 TFS",								--unit name
			inactive = true,
			type = "F-16C_50",							--aircraft type
			country = "USA",								--unit country
			base = "Reserves",								--unit base
			tasks = {},										--unit tasks
			number = 24,
		},	
		[23] = {
			name = "VMA 311",								--unit name
			player = false,									--player unit
			type = "AV8BNA",								--aircraft type
			country = "USA",								--unit country
			livery = "vma-311",								--unit livery
			liveryModex = {									--unit livery Modex  (optional)
				[100] = "vma-311d",
				},
			sidenumber = {100, 103},
			base = "LHA_Tarawa",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,
				["SEAD"] = false,
			},
			number = 4,
		},
		[24] = {
			name = "VMA 331",								--unit name
			inactive = true,
			type = "AV8BNA",								--aircraft type
			base = "Reserves",								--unit base
			tasks = {										--unit tasks
			},
			number = 30,
		},
		[25] = {
			name = "VAW-125",								--unit name
			type = "E-2C",									--aircraft type
			country = "USA",								--unit country
			livery = "",									--unit livery
			sidenumber = {600, 603},						--unit range of sidenumbers (optional)
			base = "CVN-71 Theodore Roosevelt",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["AWACS"] = true,
			},
			number = 8,
		},		
		[26] = {
			name = "R/VAW-125",								--unit name
			inactive = true,
			type = "E-2C",									--aircraft type
			country = "USA",								--unit country
			base = "Reserves",							--unit base
			skill = "High",								--unit skill
			tasks = {},									--unit tasks
			number = 1,
		},
		[27] = {
			name = "801 ARS",								--unit name
			type = "KC-135",								--aircraft type
			country = "USA",								--unit country
			livery = "Standard USAF",						--unit livery
			base = "Abu Dhabi Intl",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Refueling"] = true,
			},
			number = 4,
		},	
	},		
	["red"] = {												--side 2
		[1] = {
			name = "81 TFS",							--unit name
			type = "F-14A-135-GR",								--aircraft type
			country = "Iran",								--unit country
			livery = {"IRIAF Blue-Gray"},				--unit livery
			base = "Lar Airbase",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,				
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1.5,
				["CAP"] = 2,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,	
			},
			number = 4,
		},
		[2] = {
			name = "82 TFS",								--unit name
			inactive = true,
			type = "F-14A-135-GR",								--aircraft type
			base = "Reserves",
			skill = "High",								--unit skill
			tasks = {},									--unit tasks
			number = 24,
		},
		[3] = {
			name = "23 TFS",							--unit name
			type = "MiG-29A",								--aircraft type
			country = "Iran",							--unit country
			livery = "IRIAF sand-blue",						--unit livery
			base = "Bandar Abbas Intl",							--unit base
			skill = "high",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1.5,
				["Fighter Sweep"] = 1,	
			},
			number = 4,
		},
		[4] = {
			name = "11 TFS",								--unit name
			inactive = true,
			type = "MiG-29A",								--aircraft type
			base = "Reserves",
			skill = "Random",								--unit skill
			tasks = {},									--unit tasks
			number = 24,
		},
		[5] = {
			name = "91 TFS",								--unit name
			type = "F-4E",								--aircraft type
			country = "Iran",								--unit country
			livery = "IRIAF Asia Minor",						--unit livery
			base = "Bandar Abbas Intl",						--unit base
			skill = "Random",
			tasks = {
				["Strike"] = true,
				["SEAD"] = true,
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Anti-ship Strike"] = true,	
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,	
			},
			number = 4,
		},
		[6] = {
			name = "31 TFS",								--unit name
			inactive = true,
			type = "F-4E",								--aircraft type
			base = "Reserves",
			skill = "Random",								--unit skill
			tasks = {},									--unit tasks
			number = 24,
		},
		[7] = {
			name = "41 TFS",								--unit name
			type = "F-5E-3",								--aircraft type
			country = "Iran",						--unit country
			livery = "IR IRIAF Camo",			--unit livery
			base = "Bandar Abbas Intl",							--unit base
			skill = "Random",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Strike"] = true,				
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,	
			},
			number = 4,
		},
		[8] = {
			name = "141 TFS",								--unit name
			inactive = true,
			type = "F-5E-3",								--aircraft type
			base = "Reserves",
			skill = "Random",								--unit skill
			tasks = {},									--unit tasks
			number = 24,
		},
		[9] = {
			name = "72 TFS",								--unit name
			type = "Su-24M",								--aircraft type
			country = "Iran",								--unit country
			livery = "Iranian Air Force",									--unit livery
			base = "Shiraz Intl",						--unit base
			skill = "high",									--unit skill
			tasks = {
				["Strike"] = true,
				["Anti-ship Strike"] = true,				
				["SEAD"] = true,
				["Laser Illumination"] = false,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,	
			},
			number = 6,
		},
		[10] = {
			name = "73 TFS",								--unit name
			inactive = true,
			type = "Su-24M",								--aircraft type
			base = "Reserves",
			skill = "high",									--unit skill
			tasks = {},										--unit tasks
			number = 18,
		},
		[11] = {
			name = "51 TFS",								--unit name
			type = "MiG-29A",								--aircraft type
			country = "Iran",								--unit country
			livery = {"IRIAF blue-grey"},									--unit livery
			base = "Bandar Abbas Intl",								--unit base
			skill = "high",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1.5,
				["Fighter Sweep"] = 1,	
			},
			number = 4,
		},
		[12] = {
			name = "52 TFS",								--unit name
			inactive = true,
			type = "MiG-29A",								--aircraft type
			base = "Reserves",
			skill = "high",								--unit skill
			tasks = {},									--unit tasks
			number = 18,
		},
		[13] = {
			name = "21 TFS",							--unit name
			type = "F-5E-3",							--aircraft type
			country = "Iran",							--unit country
			livery = "IR IRIAF Camo",					--unit livery
			base = "Sirri Island",						--unit base
			skill = "high",								--unit skill
			tasks = {
				["Intercept"] = true,
				["CAP"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1.5,
				["Fighter Sweep"] = 1,	
			},
			number = 4,
		},
		[14] = {
			name = "22 TFS",								--unit name
			inactive = true,
			type = "F-5E-3",								--aircraft type
			base = "Reserves",
			skill = "high",								--unit skill
			tasks = {},									--unit tasks
			number = 22,
		},
		[15] = {
			name = "Tanker sqd",								--unit name
			type = "KC135MPRS",								--aircraft type
			country = "Iran",								--unit country
			livery = {"IRIAF"},									--unit livery
			base = "Shiraz Intl",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Refueling"] = true,
			},
			number = 4,
		},
		[16] = {
			name = "83 TFS",							--unit name
			type = "F-14A-135-GR",								--aircraft type
			country = "Iran",								--unit country
			livery = {"IRIAF Blue-Gray"},				--unit livery
			base = "Shiraz Intl",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,				
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1.5,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,	
			},
			number = 4,
		},
		[17] = {
			name = "84 TFS",								--unit name
			inactive = true,
			type = "F-14A-135-GR",								--aircraft type
			base = "Reserves",
			skill = "High",								--unit skill
			tasks = {},									--unit tasks
			number = 18,
		},
		[18] = {
			name = "21-2 TFS",							--unit name
			type = "F-5E-3",							--aircraft type
			country = "Iran",							--unit country
			livery = "IR IRIAF Camo",					--unit livery
			base = "Qeshm Island",						--unit base
			skill = "high",								--unit skill
			tasks = {
				["Intercept"] = true,
				["CAP"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,	
			},
			number = 4,
		},
		[19] = {
			name = "22-2 TFS",								--unit name
			inactive = true,
			type = "F-5E-3",								--aircraft type
			base = "Reserves",
			skill = "high",								--unit skill
			tasks = {},									--unit tasks
			number = 22,
		},
	},
}

--List of aliases to replace type names in briefing/debriefing
TypeAlias = {
}
